﻿var TaxiApp = angular.module('CouponsList', ['ngStorage', 'ngDialog', 'angularUtils.directives.dirPagination', 'ui.bootstrap']);
var company, TariffList;


TaxiApp.controller('CouponsCtrl', ['$scope', '$http', '$sessionStorage', 'ngDialog',
    function ($scope, $http, $sessionStorage, ngDialog, $confirm) {
        $scope.Role = sessionStorage.RoleType;
        $scope.RoleID = sessionStorage.RoleID;
        $scope.DisplayName = sessionStorage.UserName;
        $scope.CompanyName = sessionStorage.value;
        $scope.p_BatchNoParam = '';
        $scope.p_CouponNumber = '';
        $scope.p_CouponStatus = '0';

        if (sessionStorage.OrderId < 2) {
            window.location.href = "../../Access.html";
        }
        else {
            Localization(sessionStorage.selectedLanguage, 'user', $scope, sessionStorage);
            $scope.loading = true;
            // $('.driveradd').hide();

            if (sessionStorage.length == (undefined || 0)) {
                window.parent.location.href = "../../Index.html";
            }
            else {
                var TokenID = sessionStorage.TokenID;
                var orgOID = sessionStorage.ORGOID;
                var userOID = sessionStorage.UserOID;
                var roleType = sessionStorage.RoleType;
                var roleID = sessionStorage.RoleID;
                var companyOID = sessionStorage.CompanyOID;

                $scope.Role = sessionStorage.RoleType;


                // console.log($scope.CARTYPE)

             
                loadContents(sessionStorage.ORGOID, sessionStorage.CompanyOID, sessionStorage.UserOID, 'DT', $scope);

                $scope.Coupons = {
                    remove: function (c) {
                        $scope.loading = true;
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "DeleteCoupon/" + c.OID + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.DeleteCouponResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Coupons.get($scope.p_BatchNoParam, $scope.p_CouponNumber, $scope.p_CouponStatus);

                              


                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });


                    },
                    show() {
                        if ((($scope.p_BatchNoParam != 'undefined' && $scope.p_BatchNoParam.length > 0)
                            || ($scope.p_CouponNumber != 'undefined' && $scope.p_CouponNumber.length > 0))
                            && ($scope.p_CouponNumber != '0' || $scope.p_BatchNoParam!='0' )) {
                            if ($scope.p_BatchNoParam.length == 0)
                                $scope.p_BatchNoParam = "0";
                            if ($scope.p_CouponNumber.length == 0)
                                $scope.p_CouponNumber = "0";
                            $scope.Coupons.get($scope.p_BatchNoParam, $scope.p_CouponNumber, $scope.p_CouponStatus);
                        }
                        else
                            alert(' يجب ادخال رقم اصدار او رقم كوبون للبحث');
                       

                    },
                    get: function (p,c ,s) {
                        $scope.loading = true;
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetCouponsList/" + p + "/" +
                                c + "/" + s + "/" + userOID  + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCouponsListResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.CouponsList = JSON.parse(result.GetCouponsListResult);
                                //  console.log($scope.driverList)
                                $scope.loading = false;
                                $scope.$apply();

                            }
                        });
                    },
                    create: function () {
                        $scope.e_BatchNo = "";
                        $scope.e_Description = "";
                        $scope.e_Quantity = "";
                        $scope.e_Amount = "";
                        $('#AddModal').modal('toggle');
                    },
                    execute: function () {
                        $scope.loading = true;
                        var coupons = {
                            "BatchNo": $scope.e_BatchNo,
                            "Description": $scope.e_Description,
                            "Quantity": $scope.e_Quantity,
                            "Amount": $scope.e_Amount,

                           
                            "ModifiedBy": sessionStorage.UserOID,
                            "TokenID": sessionStorage.TokenID
                        }
                        var obj = {};

                        obj["obj"] = coupons;
                        $.ajax({
                            type: "POST",
                            url: ManagementServiceUrl + "IssueCoupons",
                            data: JSON.stringify(obj),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (data) {
                                if (data.IssueCouponsResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    $scope.loading = false;
                                    $scope.$apply();
                                    return;
                                }
                                if (data.IssueCouponsResult == '"batch_no_exisits"') {
                                    alert('رقم الاصدار موجود مسبقا، يرجى ادخال رقم اصدار جديد');
                                    $scope.loading = false;
                                    $scope.$apply();
                                    return;
                                }

                                var res = JSON.parse(data.IssueCouponsResult);
                                // var str = "Hello world, welcome to the universe.";
                                $scope.loading = false;
                                $scope.$apply();


                                //  console.log(res)
                                if (res = 'success') {
                                    $('#AddModal').modal('toggle');
                                    $scope.p_BatchNoParam = $scope.e_BatchNo;
                                    $scope.Coupons.get($scope.e_BatchNo,'0','0');

                                } else {
                                    alert(res + "حدث خطأ  ")

                                }
                            }
                        });
                    }

                }
                $scope.Export = {

                    exportToExcel: function () {
                        var filename = '';

                        var htmlTable = '<table class="alltable table table-bordered sortableTable responsive-table table-hover" id="table1"  style="direction: rtl;">';
                        htmlTable += '<thead><tr><th> <span > رقم الاصدار</span></th><th> <span > القيمة</span></th><th> <span > الكوبون</span></th></tr> </thead> <tbody>';

                        var row = "";

                        for (var i = 0; i < $scope.CouponsList.length; i++) {

                            var object = $scope.CouponsList[i];
                            filename = object.BatchNo;

                            row = '<tr class="even gradeC">';
                            row += "<td>" + object.BatchNo + "</td>";
                            row += "<td>" + object.Amount + "</td>";
                            row += "<td>" + object.Coupon + "</td>";
                            row += '</tr>';

                            htmlTable += row;
                            row = "";
                        }

                        htmlTable += "</tbody></table>";


                        $(htmlTable).table2excel({

                            type: "Text",
                            name: "Worksheet Name",

                            filename: "coupons_" + filename //do not include extension

                        });

                    }
                }


                }

            }
        }
    ]);



