﻿var TaxiApp = angular.module('SelfRegistration', ['ngStorage', 'ngDialog', 'angularUtils.directives.dirPagination', 'ui.bootstrap']);
TaxiApp.controller('SelfRegistrationCtrl', ['$scope', '$http', '$sessionStorage', 'ngDialog','EditDriverInfo',
    function ($scope, $http, $sessionStorage, ngDialog, $confirm, EditDriverInfo) {
        $scope.Role = sessionStorage.RoleType;
        $scope.RoleID = sessionStorage.RoleID;
        $scope.DisplayName = sessionStorage.UserName;
        $scope.Drivers = null;

        $scope.CompanyName = sessionStorage.value;
        if (sessionStorage.OrderId <2) {
            window.location.href = "../../Access.html";
        }
        else {
            Localization(sessionStorage.selectedLanguage, 'user', $scope, sessionStorage);
            $scope.loading = true;
            // $('.driveradd').hide();

            if (sessionStorage.length == (undefined || 0)) {
                window.parent.location.href = "../../Index.html";
            }
            else {
                var TokenID = sessionStorage.TokenID;
                var orgOID = sessionStorage.ORGOID;
                var userOID = sessionStorage.UserOID;
                var roleType = sessionStorage.RoleType;
                var roleID = sessionStorage.RoleID;
                var companyOID = sessionStorage.CompanyOID;
                $scope.Role = sessionStorage.RoleType;
         
                loadDropDownFromAppConfig("CARTYPE", userOID, companyOID, orgOID, 0, $scope);
                // console.log($scope.CARTYPE)

                loadDropDownFromAppConfig("Group", sessionStorage.UserOID, sessionStorage.CompanyOID, sessionStorage.ORGOID, 0, $scope);
                if (sessionStorage.CompanyOID != undefined || sessionStorage.ORGOID != undefined) {
                    loadDropDownFromAppConfig("COMPANY", sessionStorage.UserOID, sessionStorage.CompanyOID, sessionStorage.ORGOID, 0, $scope);
                }
                var Base64 = {
                    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

                    encode: function (e) { var t = ""; var n, r, i, s, o, u, a; var f = 0; e = Base64._utf8_encode(e); while (f < e.length) { n = e.charCodeAt(f++); r = e.charCodeAt(f++); i = e.charCodeAt(f++); s = n >> 2; o = (n & 3) << 4 | r >> 4; u = (r & 15) << 2 | i >> 6; a = i & 63; if (isNaN(r)) { u = a = 64 } else if (isNaN(i)) { a = 64 } t = t + this._keyStr.charAt(s) + this._keyStr.charAt(o) + this._keyStr.charAt(u) + this._keyStr.charAt(a) } console.log(t); return t },


                    decode: function (e) { var t = ""; var n, r, i; var s, o, u, a; var f = 0; e = e.replace(/[^A-Za-z0-9+/=]/g, ""); while (f < e.length) { s = this._keyStr.indexOf(e.charAt(f++)); o = this._keyStr.indexOf(e.charAt(f++)); u = this._keyStr.indexOf(e.charAt(f++)); a = this._keyStr.indexOf(e.charAt(f++)); n = s << 2 | o >> 4; r = (o & 15) << 4 | u >> 2; i = (u & 3) << 6 | a; t = t + String.fromCharCode(n); if (u != 64) { t = t + String.fromCharCode(r) } if (a != 64) { t = t + String.fromCharCode(i) } } t = Base64._utf8_decode(t); return t }, _utf8_encode: function (e) { e = e.replace(/rn/g, "n"); var t = ""; for (var n = 0; n < e.length; n++) { var r = e.charCodeAt(n); if (r < 128) { t += String.fromCharCode(r) } else if (r > 127 && r < 2048) { t += String.fromCharCode(r >> 6 | 192); t += String.fromCharCode(r & 63 | 128) } else { t += String.fromCharCode(r >> 12 | 224); t += String.fromCharCode(r >> 6 & 63 | 128); t += String.fromCharCode(r & 63 | 128) } } return t }, _utf8_decode: function (e) { var t = ""; var n = 0; var r = c1 = c2 = 0; while (n < e.length) { r = e.charCodeAt(n); if (r < 128) { t += String.fromCharCode(r); n++ } else if (r > 191 && r < 224) { c2 = e.charCodeAt(n + 1); t += String.fromCharCode((r & 31) << 6 | c2 & 63); n += 2 } else { c2 = e.charCodeAt(n + 1); c3 = e.charCodeAt(n + 2); t += String.fromCharCode((r & 15) << 12 | (c2 & 63) << 6 | c3 & 63); n += 3 } } return t }
                }
              
                $scope.currentPage =1
           
                $scope.SelectMake = function (make) {
                    $scope.$loading = true;
                    $scope.Lookups.loadModels(make);
                    $scope.$loading = false;
                }
                $scope.SelectGovernorate = function (gov) {
                    $scope.$loading = true;
                    $scope.Lookups.loadCities(gov);
                    $scope.$loading = false;
                }
                $scope.Lookups = {
                    load: function () {
                        $scope.$loading = true;
                        this.loadGovernorates();
                        this.loadMakes();
                        this.loadColors();
                        this.loadYears();
                        $scope.$loading = false;
                        
                    },
                    loadGovernorates: function() {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetGovernorates/" + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Governorates = JSON.parse(result.GetGovernoratesResult);
                                //  console.log($scope.driverList)
                            }
                        });
                    },
                    loadCities: function (gov, city) {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetGovernorateCitiesByName/" +gov+ "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Cities = JSON.parse(result.GetGovernorateCitiesByNameResult);
                                $scope.e_City = "";
                                $scope.$apply();
                                if (city)
                                    $scope.e_City = city;
                                $scope.$apply();

                                //  console.log($scope.driverList)
                            }
                        });
                    },
                    loadMakes: function () {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetMakes/" + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Makes = JSON.parse(result.GetMakesResult);
                                //  console.log($scope.driverList)
                            }
                        });

                    },
                    loadModels: function (make, model) {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetModelsByName/" +make+ "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Models = JSON.parse(result.GetModelsByNameResult);
                                $scope.e_Model = "";
                                $scope.$apply();
                                if (model)
                                    $scope.e_Model = model;
                                $scope.$apply();
                                //  console.log($scope.driverList)
                            }
                        });

                    },
                    loadColors: function () {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetColors/" + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Colors = JSON.parse(result.GetColorsResult);
                                //  console.log($scope.driverList)
                            }
                        });

                    },
                    loadYears: function () {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetYears/" + "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.Years = JSON.parse(result.GetYearsResult);
                                //  console.log($scope.driverList)
                            }
                        });

                    }

                }             

               $scope.Drivers = {
                    get: function () {
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "GetRegistrationRequests/"+ "/" + userOID + "/" + sessionStorage.TokenID,
                            type: "GET",
                            contentType: "application/javascript",
                            dataType: "jsonp",
                            success: function (result) {
                                if (result.GetRegistrationRequestsResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.driverList = JSON.parse(result.GetRegistrationRequestsResult);
                              //  console.log($scope.driverList)

                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });
                    }, 
                   edit: function (Driver_obj) {
                       var d = Driver_obj;
                       $scope.e_OID = d.OID
                       $scope.e_IMEI = d.ImeiNo;
                       $scope.e_Company = d.companyOID;

                        $scope.e_Name = d.name;
                        $scope.e_Mobile = d.mobile;

                        $scope.e_Nationality = d.nationality;
                        $scope.e_ID = d.national_id;
                        $scope.e_Birthdate = d.birthdate;
                        $scope.e_Gender = d.gender;
                        $scope.e_Governorate = d.district;
                        $scope.Lookups.loadCities(d.district, d.city);

                        $scope.e_Make = d.car_make;
                        $scope.Lookups.loadModels(d.car_make, d.car_model);

                        $scope.e_Color = d.car_color;
                        $scope.e_Year = d.car_year;
                        $scope.e_SerialNo = d.car_serial_no;
                        $scope.e_Plate = d.plate_no;
                        $scope.e_Letters = d.plate_letters;
                        $scope.e_Type = d.plate_type;


                        $('#EditModal').modal('toggle');
                        var DriverSetupObject = {};
                        var driverSetupObject = {


                            "OID": d.OID,
                            "CreatedBy": userOID,
                            "TokenID": sessionStorage.TokenID,
                        }

                        DriverSetupObject["driverSetupObject"] = driverSetupObject;
                        $.ajax({
                            cache: true,
                            url: ManagementServiceUrl + "getRequestDocuments",
                            type: "POST",
                            data: JSON.stringify(DriverSetupObject),
                            contentType: "application/json; charset=utf-8",
                            dataType: "json",
                            processData: true,
                            success: function (result) {
                                if (result.GetCompanyDriversResult == "access_denied") {
                                    window.parent.location.href = "../../Access.html";
                                    return;
                                }
                                $scope.driverDocuments = JSON.parse(result.getRequestDocumentsResult);
                                //  console.log($scope.driverList)

                                $scope.loading = false;
                                $scope.$apply();
                            }
                        });

                   },
                   saveEdits: function () {
                       if (this.validateInputs()) {
                           
                           var DriverSetupObject = {};

                           // var DriverSetupObject = [];
                           var registerObject = {
                               "OID": $scope.e_OID,
                               "CreatedBy": userOID,
                               "TokenID": sessionStorage.TokenID,
                               "IMEINumber": $scope.e_IMEI,
                               "CompanyId": $scope.e_Company,
                               "name": $scope.e_Name,
                               "mobile": $scope.e_Mobile,
                               "ID": $scope.e_ID,

                               "nationality": $scope.e_Nationality,
                               "dateofbirth": $scope.e_Birthdate,
                               "gender": $scope.e_Gender,
                               "district": $scope.e_Governorate,
                               "city": $scope.e_City,

                               "serialno": $scope.e_SerialNo,
                               "plate": $scope.e_Plate,
                               "letters": $scope.e_Letters,
                               "type": $scope.e_Type,
                               "make": $scope.e_Make,
                               "model": $scope.e_Model,
                               "color": $scope.e_Color,
                               "year": $scope.e_Year,
                           };

                           DriverSetupObject["obj"] = registerObject;
                           $.ajax({
                               type: "POST",
                               url: ManagementServiceUrl + "UpdateRegisterRequest",
                               data: JSON.stringify(DriverSetupObject),
                               contentType: "application/json; charset=utf-8",
                               dataType: "json",
                               processData: true,
                               success: function (data) {
                                   if (data.UpdateRegisterRequestResult == "access_denied") {
                                       window.parent.location.href = "../../Access.html";
                                       return;
                                   }
                                   var res = JSON.parse(data.UpdateRegisterRequestResult).replace("\"", "");
                                   if (res == "success") {
                                       $('#EditModal').modal('toggle');
                                       $scope.Drivers.get();

                                   }  else {
                                       alert(res + "حدث خطأ  ")
                                   }
                               },
                           });
                       } 
                   },
                   add: function (Driver_obj) {
                       var d = Driver_obj;
                       $scope.EditOID = ""
                       $scope.EditIMEINo = "";
                       $scope.EditAddToCustomerApp = true;
                       $scope.e_Name = "";
                       $scope.e_Mobile = "";

                       $scope.e_Nationality = "";
                       $scope.e_ID = "";
                       $scope.e_Birthdate = "";
                       $scope.e_Gender = "";
                       $scope.e_Governorate = "";
                       $scope.e_City = "";

                       $scope.e_Make = "";
                       $scope.e_Model = "";

                       $scope.e_Color = "";
                       $scope.e_Year = "";
                       $scope.e_SerialNo = "";
                       $scope.e_Plate = "";
                       $scope.e_Letters = "";
                       $scope.e_Type = "";
                       $('#AddModal').modal('toggle');
                   },
                   addNew: function () {
                       if (this.validateInputs()) {
                           var DriverSetupObject = {};

                           // var DriverSetupObject = [];
                           // var DriverSetupObject = [];
                           var registerObject = {
                               "OID": $scope.e_OID,
                               "CreatedBy": userOID,
                               "TokenID": sessionStorage.TokenID,
                               "IMEINumber": "0",
                               "company": companyOID,

                               "name": $scope.e_Name,
                               "mobile": $scope.e_Mobile,
                               "ID": $scope.e_ID,

                               "nationality": $scope.e_Nationality,
                               "dateofbirth": $scope.e_Birthdate,
                               "gender": $scope.e_Gender,
                               "district": $scope.e_Governorate,
                               "city": $scope.e_City,

                               "serialno": $scope.e_SerialNo,
                               "plate": $scope.e_Plate,
                               "letters": $scope.e_Letters,
                               "type": $scope.e_Type,
                               "make": $scope.e_Make,
                               "model": $scope.e_Model,
                               "color": $scope.e_Color,
                               "year": $scope.e_Year,
                           };

                           DriverSetupObject["obj"] = registerObject;
                           $.ajax({
                               type: "POST",
                               url: ManagementServiceUrl + "AddRegisterRequest",
                               data: JSON.stringify(DriverSetupObject),
                               contentType: "application/json; charset=utf-8",
                               dataType: "json",
                               processData: true,
                               success: function (data) {
                                   if (data.AddRegisterRequestResult == "access_denied") {
                                       window.parent.location.href = "../../Access.html";
                                       return;
                                   }
                                   var res = JSON.parse(data.AddRegisterRequestResult).replace("\"", "");
                                   if (res == "success") {
                                       $('#AddModal').modal('toggle');
                                       $scope.Drivers.get();

                                   }
                                  

                                   else {
                                       alert(res + "حدث خطأ  ")
                                   }
                               },
                           });

                       }
                   },
                   validateInputs: function () {

                       if ($scope.e_Name == undefined || $scope.e_Name == "") {
                           alert("يرجى ادخال اسم السائق");
                           return false;
                       } else if ($scope.e_Mobile == undefined || $scope.e_Mobile == "") {
                           alert("يرجى ادخال رقم الهاتف");
                           return false;
                       } else if ($scope.e_Mobile.length < 10) {
                           alert("رقم الهاتف غير صحيح");
                           return false;
                       } else if ($scope.e_ID == undefined || $scope.e_ID == "") {
                           alert("يرجى ادخال رقم الهوية");
                           return false;
                       } else if ($scope.e_ID.length < 9) {
                           alert("رقم الهوية غير صحيح ");
                           return false;
                       } else if ($scope.e_Nationality == undefined || $scope.e_Nationality == "") {
                           alert("يرجى تحديد الجنسية");
                           return false;
                       } else if ($scope.e_Gender == undefined || $scope.e_Gender == "") {
                           alert("يرجى تحديد الجنس");
                           return false;
                       }
                       else if ($scope.e_Birthdate == undefined || $scope.e_Birthdate == "") {
                           alert("يرجى ادخال تاريخ الميلاد");
                           return false;
                       }
                       else if ($scope.e_Governorate == undefined || $scope.e_Governorate == "") {
                           alert("يرجى تحديد المحافظة");
                           return false;
                       }
                       else if ($scope.e_City == undefined || $scope.e_City == "") {
                           alert("يرجى تحديد المدينة");
                           return false;
                       } 
                       else if ($scope.e_Plate == undefined || $scope.e_Plate == "") {
                           alert("يرجى ادخال رقم اللوحة المعدنية");
                           return false;
                       } 
                       else if ($scope.e_Make == undefined || $scope.e_Make == "") {
                           alert("يرجى تحديد نوع المركبة");
                           return false;
                       } else if ($scope.e_Model == undefined || $scope.e_Model == "") {
                           alert("يرجى تحديد طراز المركبة");
                           return false;
                       } else if ($scope.e_Color == undefined || $scope.e_Color == "") {
                           alert("يرجى تحديد لون المركبة");
                           return false;
                       } else if ($scope.e_Year == undefined || $scope.e_Year == "") {
                           alert("يرجى تحديد سنة انتاج المركبة");
                           return false;
                       } else if ($scope.e_Type == undefined || $scope.e_Type == "") {
                           alert("يرجى تحديد نوع رخصة المركبة");
                           return false;
                       } /*else if ($scope.e_IMEI == undefined || $scope.e_IMEI == "") {
                           alert("يرجى تحديد رقم الجهاز المستخدم");
                           return false;
                       }*/
                       return true;
                   },
                   accept: function (driver) {

                       $scope.e_AppEnabled = true;
                       $scope.e_OID = driver.OID;
                       $scope.e_IMEI = driver.imei_no;
                       $scope.e_Company = driver.CompayId;

                       $('#AcceptModal').modal('toggle');

                   },
                   doAccept: function () {
                       $scope.loading = true;
                       var imei = $scope.e_IMEI;
                       var service = $scope.e_ServiceType;
                       var enabled = $scope.e_AppEnabled;
                       var company = $scope.e_Company;

                       if (imei == null || imei.length == 0) {
                            alert("يجب ادخال رقم الجهاز")
                           return;
                       }

                       if (service=='undefined' || service == null) {
                           alert("يجب تحديد نوع الخدمة");
                           return;
                       }

                       if (company == 'undefined' || company == null) {
                           alert("يجب تحديد المكتب");
                           return;
                       }
                       var registerObject = {
                           "OID": $scope.e_OID,
                           "CreatedBy": userOID,
                           "TokenID": sessionStorage.TokenID,
                           "company": $scope.e_Company,
                           "imei": $scope.e_IMEI,

                           "app_enabled": enabled,
                           "service_type": service
                       };
                       var DriverSetupObject = {};
                       DriverSetupObject["obj"] = registerObject;
                       $.ajax({
                           type: "POST",
                           url: ManagementServiceUrl + "AcceptRegisterRequest",
                           data: JSON.stringify(DriverSetupObject),
                           contentType: "application/json; charset=utf-8",
                           dataType: "json",
                           processData: true,
                           success: function (data) {
                               if (data.UpdateRegisterRequestResult == "access_denied") {
                                   window.parent.location.href = "../../Access.html";
                                   return;
                               }
                               var res = JSON.parse(data.AcceptRegisterRequestResult).replace("\"", "");
                               if (res == "success") {
                                   $('#AcceptModal').modal('toggle');
                                   $scope.Drivers.get();

                               } else {
                                   alert(res + "حدث خطأ  ")
                               }
                               $scope.loading = false;
                           },
                       });


                   },
                   reject: function (request) {

                       if (confirm('هل انت متأكد من حذف الطلب؟')) {

                           var DriverSetupObject = {};

                           // var DriverSetupObject = [];
                           var driverSetupObject = {
                               "CreatedBy": sessionStorage.UserOID,
                               "OID": request.OID,
                               "RejectReason": "",
                               "TokenID": sessionStorage.TokenID,


                           };
                           DriverSetupObject["driverSetupObject"] = driverSetupObject;
                           $.ajax({
                               type: "POST",
                               url: ManagementServiceUrl + "rejectDriver",
                               data: JSON.stringify(DriverSetupObject),
                               contentType: "application/json; charset=utf-8",
                               dataType: "json",
                               processData: true,
                               success: function (data) {

                                   if (data.rejectDriverResult == "access_denied") {
                                       window.parent.location.href = "../../Access.html";
                                       return;
                                   }
                                   $scope.Drivers.get()
                               }
                           });                       } else {
                           // Do nothing!
                           console.log('Thing was not saved to the database.');
                       }
                        
                   
               
                     
                    },
                   RegisterWasl: function (oid) {
                       $scope.loading = true;
                       $.ajax({
                           cache: true,
                           url: ManagementServiceUrl + "wslRegister/" +oid+ "/" + userOID + "/" + sessionStorage.TokenID,
                           type: "GET",
                           contentType: "application/javascript",
                           dataType: "jsonp",
                           success: function (result) {
                               if (result.GetCompanyDriversResult == "access_denied") {
                                   window.parent.location.href = "../../Access.html";
                                   return;
                               }
                               $scope.driverList = JSON.parse(result.wslRegisterResult);
                               //  console.log($scope.driverList)
                               $scope.Drivers.get();
                               $scope.loading = false;
                               $scope.$apply();
                           }
                       });
                   },
                   ViewWslDtls: function (driver) {

                       $.ajax({
                           cache: true,
                           url: ManagementServiceUrl + "wslGetStatus/" + driver.OID + "/" + userOID + "/" + sessionStorage.TokenID,
                           type: "GET",
                           contentType: "application/javascript",
                           dataType: "jsonp",
                           success: function (result) {
                               if (result.GetCompanyDriversResult == "access_denied") {
                                   window.parent.location.href = "../../Access.html";
                                   return;
                               }
                               var info = JSON.parse(result.wslGetStatusResult);
                               //  console.log($scope.driverList)
                               $scope.WaslResultCode = info.WResult;
                               $scope.WaslSuccess = driver.WaslSuccess;
                               $scope.WaslResultMsg = driver.WaslResultMsg;
                               $scope.Wasl_Eligibility_Code = info.wEligibility;
                               $scope.Wasl_Eligibility_ExpiryDate = driver.Wasl_Eligibility_ExpiryDate;
                               $scope.Wasl_Rejection_Reasons = info.wRejection;

                               $scope.$apply();
                               $('#ViewWslDtlModal').modal('toggle');
                               $scope.loading = false;

                           }
                       });


                      

                   }
                   

                }
               
               $scope.removeDriver = function () {


                   var DriverSetupObject = {};

                   // var DriverSetupObject = [];
                   var driverSetupObject = {
                       "CreatedBy": sessionStorage.UserOID,
                       "OID": $scope.removeDriverOID,
                       "Reason": $scope.RejectReason,
                       "TokenID": sessionStorage.TokenID,


                   };
                   DriverSetupObject["driverSetupObject"] = driverSetupObject;
                   $.ajax({
                       type: "POST",
                       url: ManagementServiceUrl + "rejectDriver",
                       data: JSON.stringify(DriverSetupObject),
                       contentType: "application/json; charset=utf-8",
                       dataType: "json",
                       processData: true,
                       success: function (data) {

                           if (data.rejectDriverResult == "access_denied") {
                               window.parent.location.href = "../../Access.html";
                               return;
                           }
                           $scope.Drivers.get()
                           $('#RejectModal').modal('toggle');
                       }
                   });
               }
              
                $scope.Drivers.get();
                $scope.Lookups.load();
               
                // initial image index
                $scope._Index = 0;
                // if a current image is the same as requested image
                $scope.isActive = function (index) {
                    return $scope._Index === index;
                };
                // show prev image
                $scope.showPrev = function () {
                    $scope._Index = ($scope._Index > 0) ? --$scope._Index : $scope.driverDocuments.length - 1;
                };
                // show next image
                $scope.showNext = function () {
                    $scope._Index = ($scope._Index < $scope.driverDocuments.length - 1) ? ++$scope._Index : 0;
                };
                // show a certain image
                $scope.showPhoto = function (index) {
                    $scope._Index = index;
                };

               


            }
        }
    }]);

TaxiApp.service('EditDriverInfo', function ($modal) {
    var service = {};
    var self = this;
    service.open = function (idd) {
        var modalInstance = $modal.open({
            windowClass: 'EditDriverInfo',
            templateUrl: 'EditDriverInfo.html',
            controller: 'EditDriverInfoCtrl',
        });
    };



    return service;
})
TaxiApp.controller('EditDriverInfoCtrl', function ($scope, $http, $sessionStorage, ngDialog, $window, obj) {
  
    $scope.ClickClose = function () {
        $(".ngdialog-close").trigger("click");

    }
    $scope.EditItem = function () {
        var fname = $('#changed_driver_first_name').val();
        var lname = $('#changed_driver_family_name').val();
        var no = $('#changed_driver_number').val();
        if ($scope.RejectReason!=null && $scope.RejectReason != "") {
            obj.remove($scope.RejectReason)
        }
        else
            alert("يرجى ادخال اسبب الرفض ")
    }
})

